#include "ItemManager.h"



ItemManager::ItemManager()
{
}


ItemManager::~ItemManager()	//The destructor cleares the gameItems vector
{
	for (int i = 0; i < gameItems.size(); i++)
	{
		delete gameItems[i];
	}
}

void ItemManager::createItem(Block* block, GameItems::BlockType type, GameItems::StoredItems item, sf::Vector2f spawn)
{
	block->create(type, item);	//Call the block's create function, passing its type and stored item as arguments
	block->setPosition(spawn);	//Set the block's position to spawn
	block->setAlive(true);	//Set the block to be alive

	gameItems.push_back(block);	//Push the block into gameItems
}

void ItemManager::createItem(SizeableItem* item, GameItems::SpriteSize size, sf::Vector2f spawn)
{
	SizeableItem::currentItem = item;
	item->create(size);	//Call create for this SizeableItem, passing size as an argument
	item->setPosition(spawn);	//Set the item's position to spawn	
	item->setAlive(true);	//Set the item to be alive

	gameItems.push_back(item);	//Push the block into gameItems
}

void ItemManager::createItem(GameItems* item, sf::Vector2f spawn)
{
	item->setPosition(spawn);	//Set the GameItem's position to spawn
	item->setAlive(true);	//Set the GameItem to be alive

	gameItems.push_back(item);	//Push the item into gameItems
}

void ItemManager::update(float dt, Mario* mario)
{
	if (mario->isAlive())
	{	
		mario->setAirbourne(true);	//We default Mario to always being airbourne unless collisions set otherwise
		for (int i = 0; i < gameItems.size(); i++)
		{
			if (gameItems[i]->isAlive())
			{
				GameItems::currentItem = gameItems[i];	//Set the static currentItem to gameItems[i]
				if (Collision::checkBoundingBox(mario, gameItems[i]) && gameItems[i]->isCollider())	//If Mario collides with item and the item is a collidable sprite
				{
					gameItems[i]->handleCollision(mario, dt);	//Call the overidden handleCollision function for gameItems[i]
				}

				gameItems[i]->update(dt);
			}
		}
	}
}

void ItemManager::render(sf::RenderWindow* window)
{
	for (int i = 0; i < gameItems.size(); i++)
	{
		if (gameItems[i]->isAlive())
		{
			window->draw(*gameItems[i]);	//If gameItems[i] is alive, we draw it
		}
	}
}

std::vector<GameItems*> ItemManager::getItems()
{
	return gameItems;	//Return the gameItems vector
}